% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{NMImatrix}
\alias{NMImatrix}
\title{Illustration of network comparison by NMI}
\usage{
NMImatrix(ResultFolder, intModules, indicator, intconditionModules,
  conditionNames, Nsize, legendNames = NULL, plt = FALSE)
}
\arguments{
\item{ResultFolder}{where to store results}

\item{intModules}{how many modules in the background network}

\item{indicator}{identifier of current profile, served as a tag in name}

\item{intconditionModules}{a numeric vector, each of them is the number 
of modules in each condition-specific network. Or just single number}

\item{conditionNames}{a character vector, each of them is the name 
of condition. Or just single name}

\item{Nsize}{The number of genes in total}

\item{legendNames}{a character vector, each of them is the condition name 
showing up in the similarity matrix plot if applicable}

\item{plt}{a boolean value to indicate whether plot the similarity matrix}
}
\value{
NMI matrix indicating the similarity between each two networks
}
\description{
Compare the background network and a set of condition-specific network. 
returning a pair-wise matrix to show the normalized mutual information between
each pair of networks in terms of partitioning
}
\author{
Dong Li, \email{dxl466@cs.bham.ac.uk}
}
\seealso{
\code{\link{CompareAllNets}}
}
\keyword{NMI}
\keyword{differential}
\keyword{module}

