% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maaslin_meta.R
\name{maaslin_meta}
\alias{maaslin_meta}
\title{maaslin3-based meta-analytical differential abundance testing}
\usage{
maaslin_meta(
  feature_abd,
  batch,
  exposure,
  covariates = NULL,
  covariates_random = NULL,
  data,
  control = list()
)
}
\arguments{
\item{feature_abd}{feature-by-sample matrix of abundances (proportions or 
counts).}

\item{batch}{name of the batch variable. This variable in data should be a 
factor variable and will be converted to so with a warning if otherwise.}

\item{exposure}{name of the exposure variable for differential abundance 
testing.}

\item{covariates}{names of covariates to adjust for in maaslin3 
differential abundance testing models.}

\item{covariates_random}{names of random effects grouping covariates to 
adjust for in maaslin3 differential abundance testing models.}

\item{data}{data frame of metadata, columns must include exposure, batch, 
and covariates and covariates_random (if specified).}

\item{control}{a named list of additional control parameters. See details.}
}
\value{
a list, with the following components:
\describe{
\item{meta_fits_abundance}{
data frame of per-feature meta-analytical results for the abundance component, 
including columns for effect sizes, p-values and q-values, heterogeneity 
statistics such as \eqn{\tau^2} and \eqn{I^2}.
}
\item{meta_fits_prevalence}{
data frame of per-feature meta-analytical results for the prevalence component 
(logistic modeling).
}
\item{maaslin_fits}{
list of lists, each one corresponding to the fitted results of 
maaslin3 in an individual batch.
}
\item{control}{list of additional control parameters used in the function 
call.
}
}
}
\description{
\code{maaslin_meta} runs differential abundance models on microbial profiles 
within individual studies/batches using maaslin3, and aggregates per-batch 
effect sizes with a meta-analysis fixed/random effects model. It takes as 
input a feature-by-sample microbial abundance table and the accompanying 
metadata data frame which should include the batch indicator variable, the 
main exposure variable for differential abundance testing, and optional 
covariates and random covariates. The function first runs 
\code{\link[maaslin3]{maaslin3}} models on the exposure in each batch. The 
per-batch effect sizes for both abundance (linear) and prevalence (logistic) 
components are then aggregated with \code{\link[metafor]{rma.uni}} and reported 
as output. Additional parameters for both packages can be provided through 
\code{control} (see details).
}
\details{
\code{control} should be provided as a named list of the following components 
(can be a subset).
\describe{
\item{normalization}{
character. \code{normalization} parameter for maaslin3. See 
\code{\link[maaslin3]{maaslin3}} for details and allowed values. Default to 
\code{"TSS"} (total sum scaling).
}
\item{transform}{
character. \code{transform} parameter for maaslin3. See 
\code{\link[maaslin3]{maaslin3}} for details and allowed values. Default to 
\code{"LOG"} (log transformation).
}
\item{rma_method}{
character. \code{method} parameter for rma.uni. See
\code{\link[metafor]{rma.uni}} for details and allowed values. Default to 
\code{"REML"} (restricted maximum-likelihood estimator).
}
\item{output}{
character. Output directory for intermediate maaslin3 output and optional 
visualizations. Default to \code{"maaslin_meta_output"}.
}
\item{rma_conv}{
numeric. Convergence threshold for rma.uni (corresponds to 
\code{control$threshold}). See \code{\link[metafor]{rma.uni}} for details.
Default to 1e-4.
}
\item{rma_maxit}{
integer. Maximum number of iterations allowed for rma.uni (corresponds to 
\code{control$maxiter}). See \code{\link[metafor]{rma.uni}} for details.
Default to 1000.
}
\item{verbose}{
logical. Indicates whether or not verbose information will be printed.
}
}
}
\examples{
data("CRC_abd", "CRC_meta")
fit_meta <- maaslin_meta(feature_abd = CRC_abd,
                         exposure = "study_condition",
                         batch = "studyID",
                         covariates = c("gender", "age"),
                         data = CRC_meta)
}
\author{
Siyuan Ma, \email{syma.research@gmail.com}
}
