% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MgnifyClient.R, R/AllClasses.R
\docType{class}
\name{MgnifyClient}
\alias{MgnifyClient}
\alias{MgnifyClient-class}
\title{Constructor for creating a MgnifyClient object to allow the access to
MGnify database.}
\usage{
MgnifyClient(
  username = NULL,
  password = NULL,
  useCache = FALSE,
  cacheDir = tempdir(),
  showWarnings = FALSE,
  verbose = TRUE,
  clearCache = FALSE,
  ...
)
}
\arguments{
\item{username}{A single character value specifying an optional username for
authentication. (By default: \code{username = NULL})}

\item{password}{A single character value specifying an optional password for
authentication. (By default: \code{password = NULL})}

\item{useCache}{A single boolean value specifying whether to enable on-disk
caching of results during this session. In most use cases should be TRUE.
(By default: \code{useCache = FALSE})}

\item{cacheDir}{A single character value specifying a folder to contain the
local cache. Note that cached files are persistent, so the cache directory
may be reused between sessions, taking advantage of previously downloaded
results. The directory will be created if it doesn't exist already.
(By default: \code{cacheDir = tempdir()})}

\item{showWarnings}{A single boolean value specifying whether to print
warnings during invocation of some MGnifyR functions.
(By default: \code{showWarnings = FALSE})}

\item{verbose}{A single boolean value specifying whether to print extra
output during invocation of some MGnifyR functions.
(By default: \code{verbose = FALSE})}

\item{clearCache}{A single boolean value specifying whether to clear the
cache. (By default: \code{clearCache = FALSE})}

\item{...}{optional arguments:
\itemize{
  \item \strong{url} A single character value specifying an url address of
  the database. (By default:
  \code{url = "https://www.ebi.ac.uk/metagenomics/api/v1"})
}}
}
\value{
A MgnifyClient object.
}
\description{
Constructor for creating a MgnifyClient object to allow the access to
MGnify database.

A MgnifyClient object
}
\details{
All functions in the MGnifyR package take a \code{MgnifyClient} object as
their first argument. The object allows the simple handling of both user
authentication and access to private data, and manages general options for
querying the MGnify database.

An object that are required by functions of MGnifyR package.
}
\section{Slots}{

\describe{
\item{\code{databaseUrl}}{A single character value specifying an URL address of
database.}

\item{\code{authTok}}{A single character value specifying authentication token.}

\item{\code{useCache}}{A single boolean value specifying whether to use cache.}

\item{\code{cacheDir}}{A single character value specifying cache directory.}

\item{\code{showWarnings}}{A single boolean value specifying whether to show
warnings.}

\item{\code{clearCache}}{A single boolean value specifying whether to clear cache.}

\item{\code{verbose}}{A single boolean value specifying whether to show messages.}
}}

\section{Constructor}{

See  \code{\link{MgnifyClient}} for constructor.
}

\section{Accessor}{

See \code{\link{MgnifyClient-accessors}} for accessor functions.
}

\examples{
my_client <- MgnifyClient(
    useCache = TRUE, cacheDir = "/scratch/MGnify_cache_location"
    )

\dontrun{
# Use username and password to get access to non-public data
my_client <- MgnifyClient(
    username = "Webin-1122334", password = "SecretPassword",
    useCache = TRUE, cacheDir = "/scratch/MGnify_cache_location"
    )
}

}
