% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultSet_exportResults.R
\name{exportResults}
\alias{exportResults}
\title{Exports results data.frames to csv files.}
\usage{
exportResults(
  object,
  dir = "./",
  prefix = NULL,
  fNames = c("chromosome", "start")
)
}
\arguments{
\item{object}{\code{ResultSet}}

\item{dir}{Character with the path to export.}

\item{prefix}{Character with a prefix to be added to all file names.}

\item{fNames}{Names of the columns of \code{object} fData that will be added to 
the results data.frame.}
}
\value{
Files are saved into the given folder.
}
\description{
Exports results to csv files. If more than one variable is present, subfolders
with the name of the variable are created. For each variable, four files will 
be generated: probeResults.csv, dmrCateResults.csv, bumphunterResults.csv
and blockFinderResults.csv
}
\examples{
if (require(minfiData)){
set <- ratioConvert(mapToGenome(MsetEx[1:10,]))
methyOneVar <- runPipeline(set, variable_names = "sex")
exportResults(methyOneVar)
}
}
