% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindSeed.R
\name{FindSeed}
\alias{FindSeed}
\title{Find highly correlated seed of samples for gene expression matrix}
\usage{
FindSeed(gem, seed.size, iterations, initial.seed = NULL, messages = 100)
}
\arguments{
\item{gem}{Gene expression matrix with genes as rows and samples as columns}

\item{seed.size}{Size of sample seed}

\item{iterations}{Number of iterations}

\item{initial.seed}{Initial seed used, if NULL randomly chosen}

\item{messages}{frequency of progress messages}
}
\value{
Highly correlated seed
}
\description{
\code{FindSeed()} is the key function in MCbiclust. It takes a gene expression
matrix and by a stochastic method greedily searches for a seed of samples
that maximizes the correlation score of the chosen gene set.
}
\details{
Additional options allow for the search to start at a chosen seed, for instance
if a improvement to a known seed is desired. The result of \code{FindSeed()} is 
dependent on the number of iterations, with above 1000 usually providing a good
seed, and above 10000 an optimum seed.
}
\examples{
data(CCLE_small)
data(Mitochondrial_genes)

mito.loc <- which(row.names(CCLE_small) \%in\% Mitochondrial_genes)
CCLE.mito <- CCLE_small[mito.loc,]

random.seed <- sample(seq(length = dim(CCLE.mito)[2]),10)
CCLE.seed <- FindSeed(gem = CCLE.mito,
                      seed.size = 10,
                      iterations = 100,
                      messages = 100)


CorScoreCalc(CCLE.mito, random.seed)
CorScoreCalc(CCLE.mito, CCLE.seed)

CCLE.hicor.genes <- as.numeric(HclustGenesHiCor(CCLE.mito,
                                                CCLE.seed,
                                                cuts = 8))

CorScoreCalc(CCLE.mito[CCLE.hicor.genes,], CCLE.seed)
}
