% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_helper.R
\name{mbecTransform}
\alias{mbecTransform}
\title{Normalizing Transformations}
\usage{
mbecTransform(
  input.obj,
  method = c("clr", "tss"),
  offset = 0,
  required.col = NULL
)
}
\arguments{
\item{input.obj}{MbecData, phyloseq, list(counts, meta-data)}

\item{method}{one of 'CLR' or 'TSS'}

\item{offset}{(OPTIONAL) Offset in case of sparse matrix, for DEFAULT (0) an
offset will be calculated if required.}

\item{required.col}{(OPTIONAL) A vector of column names in the meta-data that
need to be present. Sanity check for subsequent steps.}
}
\value{
MbecData with transformed counts in 'clr' and 'tss' attributes
respectively.
}
\description{
Wrapper to help perform cumulative log-ratio  and total sum-scaling
transformations ,adapted from packages 'mixOmics' and robCompositions' to
work on matrices and Phyloseq objects alike.
}
\details{
The function returns an MbecData object with transformed counts and covariate
information. Input for the data-set can be of type MbecData, phyloseq or a
list that contains counts and covariate data. Correct orientation of counts
will be handled internally, as long as both abundance table contain sample
names.
}
\examples{
# This will return the cumulative log-ratio transformed counts in an
# MbecData object.
data(dummy.mbec)
mbec.CLR <- mbecTransform(input.obj=dummy.mbec, method="clr", offset=0,
required.col=c("batch","group"))

# This will return total sum-scaled counts in an MbecData object.
mbec.CLR <- mbecTransform(input.obj=dummy.mbec, method="tss", offset=0,
required.col=c("batch","group"))
}
\keyword{CLR}
\keyword{TSS}
\keyword{Transformation}
