% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbecs_corrections.R
\name{mbecRunCorrections}
\alias{mbecRunCorrections}
\title{Run Correction Pipeline}
\usage{
mbecRunCorrections(
  input.obj,
  model.vars = c("batch", "group"),
  type = "clr",
  method = c("ruv3", "bmc", "bat", "rbe", "pn", "svd", "pls"),
  nc.features = NULL
)
}
\arguments{
\item{input.obj}{Phyloseq object or a list that contains numeric matrix and
meta-data table. Requires sample names as row/col-names to handle correct
orientation.}

\item{model.vars}{Two covariates of interest to select by first variable
selects panels and second one determines coloring.}

\item{type}{One of 'otu', 'tss' or 'clr' to determine the abundance matrix
to use for evaluation.}

\item{method}{algorithms to use}

\item{nc.features}{(OPTIONAL) A vector of features names to be used as
negative controls in RUV-3. If not supplied, the algorithm will use an 'lm'
to find pseudo-negative controls}
}
\value{
an object of class MbecDataSet
}
\description{
Run all correction algorithms selected by method and add corrected counts
as matrices to the data-set.
}
\examples{
# This call will use 'ComBat' for batch effect correction and store the new
# counts in a list-obj in the output.
data(dummy.mbec)
study.obj <- mbecRunCorrections(input.obj=dummy.mbec,
model.vars=c("batch","group"), method=c("bat","bmc"))

# This call will use 'Percentile Normalization' for batch effect correction
# and replace the old count matrix.
study.obj <- mbecRunCorrections(dummy.mbec, model.vars=c("batch","group"),
method=c("pn"))
}
\keyword{Batch-Effect}
\keyword{Correction}
\keyword{Pipeline}
