% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SingleCellAssay-methods.R
\name{magic_assay_names}
\alias{magic_assay_names}
\alias{assay_idx}
\alias{assay,SingleCellAssay,missing-method}
\alias{defaultAssay}
\title{Default \code{assay} returned}
\usage{
magic_assay_names()

assay_idx(x)

\S4method{assay}{SingleCellAssay,missing}(x, i, withDimnames = TRUE, ...)
}
\arguments{
\item{x}{\code{SingleCellAssay}}

\item{i}{must be \code{missing} for this method to apply}

\item{withDimnames}{
    A \code{logical(1)}, indicating whether the dimnames of the
    SummarizedExperiment object should be applied (i.e. copied)
    to the extracted assays. More precisely, setting
    \code{withDimnames=FALSE} in the \emph{getter} returns the
    assays \emph{as-is} whereas setting \code{withDimnames=FALSE}
    return them with possibly modified dimnames.

    Setting \code{withDimnames=FALSE} in the \emph{setter} (\code{assays<-})
    is required when the dimnames on the supplied assays are not identical
    to the dimnames on the SummarizedExperiment object; it does not
    influence actual assignment of dimnames to assays (they're always
    stored as-is).

    Note that \preformatted{  assays(x, withDimnames=FALSE) <- assays(x, withDimnames=FALSE)}
    is guaranteed to always work and be a no-op. This is not the case
    if \code{withDimnames=TRUE} is used or if \code{withDimnames} is
    not specified.
  }

\item{...}{passed to parent method}
}
\description{
Methods in this package operate on log-transformed (multiplicative scale) expression.
We attempt to check for this at construction, and then over-ride the \code{assay} method to return the "layer" containing such log-transformed data.
}
\details{
By default we return the assay whose names, as given by \code{assayNames(x)}, matches the first element in the vector \code{c('thresh', 'et', 'Et', 'lCount', 'logTPM', 'logCounts', 'logcounts')}.
}
\section{Functions}{
\itemize{
\item \code{magic_assay_names()}: list of names assumed to represent log-transformed data, in order of usage preference

\item \code{assay_idx()}: what index is returned by default by `assay`

}}
\examples{
data(vbetaFA)
assay(vbetaFA)[1:3,1:3]
assay(vbetaFA, 'thresh', withDimnames = FALSE) = assay(vbetaFA)*0 - 9 
assay(vbetaFA)[1:3, 1:3]
}
