% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSEA-by-boot.R
\name{applyFlat}
\alias{applyFlat}
\title{Apply a vectorized binary operation recycling over last dimension}
\usage{
applyFlat(x, y, FUN = "-")
}
\arguments{
\item{x}{array, order K}

\item{y}{array, order K-1}

\item{FUN}{vectorized binary operation}
}
\value{
array, order K equal to FUN(x,y)
}
\description{
When x is an array of order K, and y is an array of order K-1,
whose dimensions otherwise agree,
apply FUN by recycling y as necessary over dimension K of x.
}
\examples{
##Dumb example, could be done with scale(...,scale=FALSE)
x0 = matrix(1:10, nrow=2)
y0 = rowMeans(x0)
dim(y0) = c(1, 2)
x1 = MAST:::applyFlat(x0,y0)
stopifnot(rowMeans(x1)==0)
}
