% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getOverlappingQTL}
\alias{getOverlappingQTL}
\title{getOverlappingQTL}
\usage{
getOverlappingQTL(meth.qtl.list, type = "SNP")
}
\arguments{
\item{meth.qtl.list}{A list of \code{\link{MethQTLResult-class}} objects to be merged}

\item{type}{The type of annotation to be overlapped. Needs to be \code{'SNP'}, \code{'CpG'} or \code{'cor.block'}}
}
\value{
A \code{data.frame} with the methQTL interactions and an additional column specifying where the interaction
displayed has been found. This value is generated from the \code{names()} argument of \code{meth.qtl.list}.
}
\description{
This function merges the QTLs given and returns the methQTL table in a merged format.
}
\examples{
meth.qtl.res.1 <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl.res.2 <- meth.qtl.res.1
res <- getOverlappingQTL(list(A=meth.qtl.res.1,B=meth.qtl.res.2),type="SNP")
}
\author{
Michael Scherer
}
