% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{pipeline}
\alias{pipeline}
\title{pipeline with report generation}
\usage{
pipeline(filepath,sheet_name=NULL,number_of_replicates,number_of_conditions,
control=FALSE,save.files=TRUE,MACSQuant.obj=NULL)
}
\arguments{
\item{filepath}{path of the excel file}

\item{sheet_name}{Name of the sheet to load
(optional, first sheet is default)}

\item{number_of_replicates}{For each condition, the number of duplicates
(must be the same for all conditions)}

\item{number_of_conditions}{The number of conditions tested
(eg: Drug 1 alone, Drug 2 alone)}

\item{control}{Is there a control in this experiment (eg: Staurosporin)}

\item{save.files}{Used to save the image in the output folder}

\item{MACSQuant.obj}{object of class MACSQuant}
}
\value{
A formatted report file along with intermediates results
}
\description{
Loads user's data, prompt a graphical representation of a 96
well plate and let the user select where the duplicates of each
condition were placed. Use for reordering excel file.
Plate image with selection can also be saved in the form of a png
file in the output_MQ directory.

Also generates a complete report with the graphics
}
\examples{
print("run manually, requires user input")
filepath <- system.file("extdata", "SingleDrugs.xlsx",
    package = "MACSQuantifyR")
# pipeline(filepath,3,5)
# let you select 5 conditions of 3 replicates each
}
