% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonSeqsPlot.R
\name{commonSeqsPlot}
\alias{commonSeqsPlot}
\title{Common sequences plot}
\usage{
commonSeqsPlot(sample1, sample2, productive.aa, show = "common")
}
\arguments{
\item{sample1}{A name of a sample in a list of data frames generated by the 
LymphoSeq function productiveSeq.}

\item{sample2}{A name of a sample in a list of data frames generated by the 
LymphoSeq function productiveSeq.}

\item{productive.aa}{A list of data frames of productive amino acid sequences 
produced by the LymphoSeq function productiveSeq containing the 
samples to be compared.}

\item{show}{A character vector specifying whether only the common sequences 
should be shown or all sequences.  Available options are "common" or "all".}
}
\value{
Returns a frequency scatter plot of two samples showing only the 
shared sequences.
}
\description{
Creates a scatter plot of just the sequences in common between two samples.
}
\details{
The plot is made using the package ggplot2 and can be reformatted
using ggplot2 functions.  See examples below.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

commonSeqsPlot("TRB_Unsorted_32", "TRB_Unsorted_83", 
   productive.aa = productive.aa)

# Change the X and Y axises to log-10 scale
commonSeqsPlot("TRB_Unsorted_32", "TRB_Unsorted_83", 
   productive.aa = productive.aa) +
   ggplot2::scale_x_log10() + 
   ggplot2::scale_y_log10() + 
   ggplot2::annotation_logticks(sides = "bl")
}
\seealso{
An excellent resource for examples on how to reformat a ggplot can 
be found in the R Graphics Cookbook online (\url{http://www.cookbook-r.com/Graphs/}).
}
