% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commonSeqsBar.R
\name{commonSeqsBar}
\alias{commonSeqsBar}
\title{Common sequences bar plot}
\usage{
commonSeqsBar(productive.aa, samples, color.sample = NULL,
  color.intersection = NULL, color = "#377eb8", labels = "no")
}
\arguments{
\item{productive.aa}{A list data frames of of productive amino acid sequences 
generated by LymphoSeq function productiveSeq where the aggregate parameter 
was set to "aminoAcid".}

\item{samples}{The names of two or more samples in the productive.aa 
list whose intersections will shown.}

\item{color.sample}{The name of a single sample in the productive.aa list whose 
sequences will be colored in all samples that they appear in.}

\item{color.intersection}{The names of two or more samples in the productive.aa 
list whose intersections will be colored.}

\item{color}{A character vector of a color name that will be used highlight a selected 
sample or multiple sample intersections.}

\item{labels}{A character vector indicating whether the number of 
intersecting sequences should be shown on the tops of the bars.  Options 
include "yes" or "no".}
}
\value{
Returns an UpSetR bar plot showing the number of intersecting sequences 
across multiple samples.
}
\description{
Creates an UpSetR bar plot showing the number of intersecting sequences across 
multiple samples.  This function is useful when more than 3 samples are being 
compared.
}
\examples{
file.path <- system.file("extdata", "TCRB_sequencing", package = "LymphoSeq")

file.list <- readImmunoSeq(path = file.path)

productive.aa <- productiveSeq(file.list = file.list, aggregate = "aminoAcid")

commonSeqsBar(productive.aa = productive.aa, samples = c("TRB_CD4_949", "TRB_CD8_949", 
"TRB_Unsorted_949", "TRB_Unsorted_1320"), color.sample = "TRB_CD8_949")
}
