% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LipidTrend.R
\docType{package}
\name{LipidTrend}
\alias{LipidTrend-package}
\alias{LipidTrend}
\title{LipidTrend: Analysis and Visualization of Lipid Feature Tendencies}
\description{
The LipidTrend package provides tools for analyzing and visualizing trends
in lipidomics data. It implements statistical methods for identifying
significant changes in lipid abundances across different features,
with support for both one-dimensional and two-dimensional analyses.
}
\section{Main functions}{

\itemize{
\item \code{\link{analyzeLipidRegion}}: Analyzing lipid trends using permutation
tests and Gaussian kernel smoothing
\item \code{\link{plotRegion1D}}: Visualize one-dimensional lipid trends
\item \code{\link{plotRegion2D}}: Create two-dimensional visualizations of
lipid trends
}
}

\section{Vignettes}{

See the package vignettes for detailed workflows:
\code{vignette('LipidTrend')}
}

\section{Installation}{

To install from Bioconductor, use:
\preformatted{
if (!requireNamespace('BiocManager', quietly=TRUE))
    install.packages('BiocManager')
BiocManager::install('LipidTrend')
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/BioinfOMICS/LipidTrend}
  \item Report bugs at \url{https://github.com/BioinfOMICS/LipidTrend/issues}
}

}
\author{
\strong{Maintainer}: Wei-Chung Cheng \email{chenglabomics@gmail.com} (\href{https://orcid.org/0000-0002-1229-4857}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Chia-Hsin Liu [contributor]
  \item Pei-Chun Shen [contributor]
  \item Wen-Jen Lin [contributor]
  \item Hung-Ching Chang [contributor]
  \item Meng-Hsin Tsai [contributor]
}

}
\keyword{internal}
