% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateModelPerformance.R
\name{evaluateModelPerformance}
\alias{evaluateModelPerformance}
\title{Evaluate model performances}
\usage{
evaluateModelPerformance(data, cl = 1, valid.times = 10,
  feature.ranking = NULL, feature.nb = NULL,
  numcores = ifelse(.Platform$OS.type == "windows", 1, parallel::detectCores()
  - 1), file.prefix = NULL, kernel = "linear", cost = NULL,
  gamma = NULL)
}
\arguments{
\item{data}{data.frame containing the training set}

\item{cl}{integer indicating the column number corresponding to the response vector that classify positive and negative regions (default = 1)}

\item{valid.times}{Integer indicating how many times the training set will be split for the cross validation step (default = 10). This number must be smaller than positive and negative sets sizes.}

\item{feature.ranking}{List of ordered features.}

\item{feature.nb}{the optimal number of feature to use from the list of ordered features.}

\item{numcores}{Number of cores to use for parallel computing (default: the number of available cores in the machine - 1)}

\item{file.prefix}{A character string that will be used as a prefix followed by "_ROCR_perf.png" for the result plot file, if it is NULL (default), no plot is returned}

\item{kernel}{SVM kernel, a character string: "linear" or "radial". (default = "radial")}

\item{cost}{The SVM cost parameter for both linear and radial kernels. If NULL (default), the function \code{mcTune} is run.}

\item{gamma}{The SVM gamma parameter for radial kernel. If radial kernel and NULL (default), the function \code{mcTune} is run.}
}
\value{
A list with two objects.
\item{probs}{The predictions computed by the model for each subset during the cross-validation}
\item{labels}{The actual class for each subset}
}
\description{
\code{evaluateModelPerformance} function computes the precision and recall measures to evaluate the model through cross validation steps using \code{ROCR} package.
}
\examples{
data(crm.features)
data(feature.ranking)
#probs.labels.list <- evaluateModelPerformance(data.granges=crm.features,
#    feature.ranking=feature.ranking, feature.nb=50,
#    file.prefix = "test")
#names(probs.labels.list[[1]])
}

