% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRcell.R
\name{LRcell_gene_enriched_scores}
\alias{LRcell_gene_enriched_scores}
\title{Find most enriched cell types in bulk DE genes by Logistic Regression}
\usage{
LRcell_gene_enriched_scores(
  expr,
  annot,
  power = 1,
  parallel = TRUE,
  n.cores = 4
)
}
\arguments{
\item{expr}{Expression matrix with rows as genes and columns as cells, can be
an object of Matrix or dgCMatrix or a dataframe.}

\item{annot}{Cell type annotation named vector with names as cell ids and
values as cell types.}

\item{power}{The penalty on fraction of cells expressing the genes.}

\item{parallel}{Whether to run it in parallel.}

\item{n.cores}{How many cores to use in parallel mode.}
}
\value{
A numeric matrix with rows as genes and columns as cell types,
values are gene enrichment scores.
}
\description{
This is a function which takes marker genes from single-cell RNA-seq as
reference to calculate the enrichment of certain cell types in bulk DEG
analysis. This algorithm borrows from Marques et al, 2016 (https://science.sciencemag.org/content/352/6291/1326.long).
}
