% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadRegionDB.R
\name{readRegionSetAnnotation}
\alias{readRegionSetAnnotation}
\title{Given a folder containing region collections in subfolders, this function
will either read the annotation file if one exists, or create a generic
annotation file.}
\usage{
readRegionSetAnnotation(
  dbLocation,
  collections = NULL,
  refreshCaches = FALSE,
  refreshSizes = TRUE,
  useCache = TRUE
)
}
\arguments{
\item{dbLocation}{folder where your regionDB is stored.}

\item{collections}{Restrict the database loading to this list of collections
Leave NULL to load the entire database (Default).}

\item{refreshCaches}{should I recreate the caches? Default: FALSE}

\item{refreshSizes}{should I refresh the size files? Default:TRUE}

\item{useCache}{Use simpleCache to store results and load them?}
}
\value{
Region set annotation (data.table)
}
\description{
Given a folder containing region collections in subfolders, this function
will either read the annotation file if one exists, or create a generic
annotation file.
}
\examples{
dbPath = system.file("extdata", "hg19", package="LOLA")
regionAnno = readRegionSetAnnotation(dbLocation=dbPath)
}
