% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.plugin.R
\name{discretize1d.uniform_frequency}
\alias{discretize1d.uniform_frequency}
\title{Discretize a set of continuous data into 1-dimensional bins by uniform frequency}
\usage{
discretize1d.uniform_frequency(x)
}
\arguments{
\item{x}{a numeric vector of a random variable.}
}
\value{
discretize1d.uniform_frequency returns a one-dimensional count table.
}
\description{
discretize1d.uniform_frequency assigns the observations of a continuous random variables to bins according to the "uniform frequency" method,
and returns a corresponding count table.
}
\details{
Uniform frequency-based method ("uniform_frequency") divides the continuous data into N bins with (approximate) equal count number.
The number of bins N is initialized into a round-off value according to the square root of the data size.
}
\examples{
# a numeric vector corresponding to a continuous random variable
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)

# corresponding count table estimated by "uniform frequency" algorithm
discretize1d.uniform_frequency(x)
}
