% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.plugin.R
\name{PMI.plugin}
\alias{PMI.plugin}
\title{A plug-in calculator for evaluating the part mutual information}
\usage{
PMI.plugin(probs, unit = c("log", "log2", "log10"))
}
\arguments{
\item{probs}{the joint probability distribution table of three random variables.}

\item{unit}{the base of the logarithm. The default is natural logarithm, which is "log".
For evaluating entropy in bits, it is suggested to set the unit to "log2".}
}
\value{
PMI.plugin returns the part mutual information.
}
\description{
PMI.plug measures the non-linearly direct dependencies between two variables conditioned on the third one
form the joint probability distribution table.
}
\examples{
# three numeric vectors corresponding to three continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)
z <- c(3.0, 7.0, 2.0,  11,  10,  10,  14, 2.0,  11)

# corresponding joint count table estimated by "uniform width" algorithm
count_xyz <- discretize3D(x, y, z, "uniform_width")

# the joint probability distribution table of the count data
library("entropy")
probs_xyz <- freqs.empirical(count_xyz)

# corresponding part mutual information
PMI.plugin(probs_xyz)
}
\references{
Zhao, J., Zhou, Y., Zhang, X., & Chen, L. (2016). Part mutual information for quantifying direct associations in networks.
Proceedings of the National Academy of Sciences of the United States of America, 113(18), 5130-5135.
}
