% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information.measure.R
\name{CMI.measure}
\alias{CMI.measure}
\title{A comprehensive function for estimating conditional mutual information}
\usage{
CMI.measure(
  XYZ,
  method = c("ML", "Jeffreys", "Laplace", "SG", "minimax", "shrink"),
  lambda.probs,
  unit = c("log", "log2", "log10"),
  verbose = TRUE
)
}
\arguments{
\item{XYZ}{a joint count distribution table of three random variables.}

\item{method}{six probability estimation algorithms are available, "ML" is the default.}

\item{lambda.probs}{the shrinkage intensity, only called when the probability estimator is "shrink".}

\item{unit}{the base of the logarithm. The default is natural logarithm, which is "log".
For evaluating entropy in bits, it is suggested to set the unit to "log2".}

\item{verbose}{a logic variable. if verbose is true, report the shrinkage intensity.}
}
\value{
CMI.measure returns the conditional mutual information.
}
\description{
The CMI.measure function is used to calculate the expected mutual information between two random variables conditioned on the third one
from the joint count table.
}
\details{
Six probability estimation methods are available to evaluate the underlying bin probability from observed counts: \cr
method = "ML": maximum likelihood estimator, also referred to empirical probability, \cr
method = "Jeffreys": Dirichlet distribution estimator with prior a = 0.5, \cr
method = "Laplace": Dirichlet distribution estimator with prior a = 1, \cr
method = "SG": Dirichlet distribution estimator with prior a = 1/length(XY), \cr
method = "minimax": Dirichlet distribution estimator with prior a = sqrt(sum(XY))/length(XY), \cr
method = "shrink": shrinkage estimator.
}
\examples{
# three numeric vectors corresponding to three continuous random variables
x <- c(0.0, 0.2, 0.2, 0.7, 0.9, 0.9, 0.9, 0.9, 1.0)
y <- c(1.0, 2.0,  12, 8.0, 1.0, 9.0, 0.0, 3.0, 9.0)
z <- c(3.0, 7.0, 2.0,  11,  10,  10,  14, 2.0,  11)

# corresponding joint count table estimated by "uniform width" algorithm
XYZ <- discretize3D(x, y, z, "uniform_width")

# corresponding conditional mutual information
CMI.measure(XYZ)
}
\references{
#' Hausser, J., & Strimmer, K. (2009). Entropy Inference and the James-Stein Estimator, with Application to Nonlinear Gene Association Networks.
Journal of Machine Learning Research, 1469-1484.
}
