% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.set_globals.R
\name{set_globals}
\alias{set_globals}
\title{Set up global variables for an InPAS analysis}
\usage{
set_globals(
  genome = NULL,
  TxDb = NULL,
  EnsDb = NULL,
  outdir = NULL,
  chr2exclude = c("chrM", "MT", "Pltd", "chrPltd"),
  lockfile = tempfile(tmpdir = getInPASOutputDirectory())
)
}
\arguments{
\item{genome}{An object \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}. To make things easy, we
suggest users creating a \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} instance from the
reference genome used for read alignment. For details, see the
documentation of \code{\link[BSgenome:AdvancedBSgenomeForge]{BSgenome::forgeBSgenomeDataPkg()}}.}

\item{TxDb}{An object of \link[GenomicFeatures:TxDb-class]{GenomicFeatures::TxDb}}

\item{EnsDb}{An object of \link[ensembldb:EnsDb-class]{ensembldb::EnsDb}}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{chr2exclude}{A character vector, NA or NULL, specifying chromosomes or
scaffolds to be excluded for InPAS analysis. \code{chrM} and alternative scaffolds
representing different haplotypes should be excluded.}

\item{lockfile}{A character(1) vector, specifying a file name used for
parallel writing to a SQLite database}
}
\description{
Set up global variables for an InPAS analysis
}
