% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.setup_sqlitedb.R
\name{setup_sqlitedb}
\alias{setup_sqlitedb}
\title{Create an SQLite database for storing metadata and paths to coverage files}
\usage{
setup_sqlitedb(metadata, outdir = getInPASOutputDirectory())
}
\arguments{
\item{metadata}{A path to a tab-delimited file, with columns "tag", "condition",
and "bedgraph_file", storing a unique name tag for each sample, a condition
name for each sample, such as "treatment" and "control", and a path to the
bedgraph file for each sample}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}
}
\value{
A character(1) vector, the path to the SQLite database
}
\description{
Create an SQLite database with five tables, "metadata","sample_coverage",
"chromosome_coverage", "CPsites", and "utr3_coverage", for storing metadata
(sample tag, condition, paths to bedgraph files, and sample total read
coverage), sample-then-chromosome-oriented coverage files (sample tag,
chromosome, paths to bedgraph files for each chromosome), and paths to
chromosome-then-sample-oriented coverage files (chromosome, paths to
bedgraph files for each chromosome), CP sites on each chromosome (chromosome,
paths to cpsite files), read coverage for 3' UTR and last CDS regions on each
chromosome (chromosome, paths to utr3 coverage file), respectively
}
\examples{
if (interactive()) {
  bedgraphs <- system.file("extdata", c(
    "Baf3.extract.bedgraph",
    "UM15.extract.bedgraph"
  ),
  package = "InPAS"
  )
  tags <- c("Baf3", "UM15")
  metadata <- data.frame(
    tag = tags,
    condition = c("Baf3", "UM15"),
    bedgraph_file = bedgraphs
  )
  outdir <- tempdir()
  write.table(metadata,
    file = file.path(outdir, "metadata.txt"),
    sep = "\t", quote = FALSE, row.names = FALSE
  )
  sqlite_db <- setup_sqlitedb(
    metadata =
      file.path(outdir, "metadata.txt"),
    outdir
  )
}
}
\author{
Haibo Liu
}
