% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03.get_ssRleCov.R
\name{get_ssRleCov}
\alias{get_ssRleCov}
\title{Get Rle coverage from a bedgraph file for a sample}
\usage{
get_ssRleCov(
  bedgraph,
  tag,
  genome = getInPASGenome(),
  sqlite_db,
  future.chunk.size = NULL,
  outdir = getInPASOutputDirectory(),
  chr2exclude = getChr2Exclude()
)
}
\arguments{
\item{bedgraph}{A path to a bedGraph file}

\item{tag}{A character(1) vector, a name tag used to label the bedgraph file.
It must match the tag specified in the metadata file used to setup the
SQLite database}

\item{genome}{an object \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}. To make things easy, we
suggest users creating a \link[BSgenome:BSgenome-class]{BSgenome::BSgenome} instance from the
reference genome used for read alignment. For details, see the
documentation of \code{\link[BSgenome:BSgenomeForge]{BSgenome::forgeBSgenomeDataPkg()}}.}

\item{sqlite_db}{A path to the SQLite database for InPAS, i.e. the output of
\code{\link[=setup_sqlitedb]{setup_sqlitedb()}}.}

\item{future.chunk.size}{The average number of elements per future
("chunk"). If Inf, then all elements are processed in a single future.
If NULL, then argument future.scheduling = 1 is used by default. Users can
set future.chunk.size = total number of elements/number of cores set for
the backend. See the future.apply package for details. You may adjust
this number based based on the available computing resource: CPUs and RAM.
This parameter affects the time for converting coverage from bedgraph to Rle.}

\item{outdir}{A character(1) vector, a path with write permission for storing
InPAS analysis results. If it doesn't exist, it will be created.}

\item{chr2exclude}{A character vector, NA or NULL, specifying chromosomes or
scaffolds to be excluded for InPAS analysis. \code{chrM} and alternative scaffolds
representing different haplotypes should be excluded.}
}
\value{
A data frame, as described below.
\describe{
\item{tag}{the sample tag}
\item{chr}{chromosome name}
\item{coverage_file}{path to Rle coverage files for each chromosome
per sample tag}
}
}
\description{
Get RLe coverage from a bedgraph file for a sample
}
\examples{
if (interactive()) {
  library(BSgenome.Mmusculus.UCSC.mm10)
  genome <- BSgenome.Mmusculus.UCSC.mm10
  bedgraphs <- system.file("extdata", c(
    "Baf3.extract.bedgraph",
    "UM15.extract.bedgraph"
  ),
  package = "InPAS"
  )
  tags <- c("Baf3", "UM15")
  metadata <- data.frame(
    tag = tags,
    condition = c("Baf3", "UM15"),
    bedgraph_file = bedgraphs
  )
  outdir <- tempdir()
  write.table(metadata,
    file = file.path(outdir, "metadata.txt"),
    sep = "\t", quote = FALSE, row.names = FALSE
  )

  sqlite_db <- setup_sqlitedb(
    metadata = file.path(
      outdir,
      "metadata.txt"
    ),
    outdir
  )
  addLockName()
  coverage_info <- get_ssRleCov(
    bedgraph = bedgraphs[1],
    tag = tags[1],
    genome = genome,
    sqlite_db = sqlite_db,
    outdir = outdir,
    chr2exclude = "chrM"
  )
  # check read coverage depth
  db_connect <- dbConnect(drv = RSQLite::SQLite(), dbname = sqlite_db)
  dbReadTable(db_connect, "metadata")
  dbDisconnect(db_connect)
}
}
\author{
Jianhong Ou, Haibo Liu
}
