% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00.get_seqLen.R
\name{get_seqLen}
\alias{get_seqLen}
\title{Get sequence lengths for chromosomes/scaffolds}
\usage{
get_seqLen(genome = getInPASGenome(), chr2exclude = getChr2Exclude())
}
\arguments{
\item{genome}{An object of \link[BSgenome:BSgenome-class]{BSgenome::BSgenome}}

\item{chr2exclude}{A character vector, NA or NULL, specifying chromosomes or
scaffolds to be excluded for InPAS analysis. \code{chrM} and alternative scaffolds
representing different haplotypes should be excluded.}
}
\value{
A named numeric vector containing lengths per seqname, with the
seqnames as the names
}
\description{
Get sequence lengths for chromosomes/scaffolds from a
\link[BSgenome:BSgenome-class]{BSgenome::BSgenome} object
}
\examples{
library(BSgenome.Mmusculus.UCSC.mm10)
genome <- BSgenome.Mmusculus.UCSC.mm10
InPAS:::get_seqLen(
  genome = genome,
  chr2exclude = "chrM"
)
}
\seealso{
\link[Seqinfo:Seqinfo-class]{Seqinfo::Seqinfo}
}
\author{
Jianhong Ou, Haibo Liu
}
\keyword{internal}
