% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_intact.R
\name{multi_intact}
\alias{multi_intact}
\title{Compute Multi-INTACT prior parameter estimates and gene product relevance
probabilities.}
\usage{
multi_intact(
  df,
  chisq_dof = 2,
  prior_fun = linear,
  t = 0.05,
  D = NULL,
  xwas_priors = .pi1_fun(z_vec = qnorm(pchisq(df$chisq, df = chisq_dof, lower.tail =
    FALSE)/2)),
  xwas_BFs = NULL,
  bf_type = "wakefield",
  K = c(1, 2, 4, 8, 16),
  glcp_aggreg = "max",
  em_algorithm = TRUE,
  pi0 = 1 - .pi1_fun(z_vec = qnorm(pchisq(df$chisq, df = chisq_dof, lower.tail =
    FALSE)/2)),
  pi_init = c(pi0, rep(1 - pi0, 3)/3),
  return_model_posteriors = FALSE
)
}
\arguments{
\item{df}{A data frame containing at least the following six columns:
(1)'gene' contains the gene ID,
(2)'GLCP_1' contains the numeric pairwise colocalization probability for the
complex trait and gene product 1,
(3)'GLCP_2' contains the numeric pairwise colocalization probability for the
complex trait and gene product 2,
(4) 'z_1' A numeric vector of TWAS test statistics for gene product 1,
(5) 'z_2' A numeric vector of TWAS test statistics for gene product 2, and
(6)'chisq' A numeric vector of multivariate Wald chi-square test statistics.}

\item{chisq_dof}{A numeric scalar or vector with the degrees of freedom of
the chi-square test statistics under the null. Default is 2 for all genes.}

\item{prior_fun}{A function to transform an aggregated colocalization
 probability into a prior.
Options are linear, step, expit, and hybrid.}

\item{t}{A hard threshold for the aggregated colocalization probability.
 Values below this number will be
shrunk to zero.
 This argument is used in the user-specified prior function. Default value
 for the step
 prior is 0.5. Default value is 0.05 for all other prior functions.}

\item{D}{A curvature shrinkage parameter. Lower values of D will result in a
steeper curve.
Default is 0.1. This parameter should only be specified if the user selects
the expit or hybrid
prior function and does not wish to use the default value.}

\item{xwas_priors}{An optional vector of user-specified gene-specific priors
for the joint regression of the complex trait on the two gene product levels.
If no input is supplied, Multi-INTACT computes a scalar prior using the
multivariate Wald test data
(see the corresponding manuscript for more details).}

\item{xwas_BFs}{A vector of Bayes factors for the joint regression of the
complex trait on the two gene product levels for the gene of interest.
This is an alternative
option if the user wishes to directly specify Bayes factors instead of
 computing them from
the chi-square statistics.}

\item{bf_type}{Method used to compute Bayes factors. Default is 'wakefield',
but a formula from Johnson (2005) 'johnson' is also available.}

\item{K}{A vector of values over which Bayesian model averaging is performed.}

\item{glcp_aggreg}{Function used to aggregate pairwise coloclization
probabilities. Default is taking the max ('max'), but 1-prod(1-GLCP)
'one_minus_prod_one_minus' is also available.}

\item{em_algorithm}{Should the function run the EM algorithm to compute
gene product relevance probabilities (TRUE/FALSE)?}

\item{pi0}{Estimate for the parameter pi0.}

\item{pi_init}{Initialization of prior parameters to be estimated. The first
entry should be the qvalue estimate for pi0. The second parameter should
be the gene-product-1-only parameter; the third should be the
gene-product-2-only parameter, and the fourth should be the
gene-product-1+2-parameter. Entries must sum to 1.}

\item{return_model_posteriors}{Should the function return model posteriors
in addition to the gene product relevance probabilities (TRUE/FALSE)?}
}
\value{
A list containing:
(1) a data frame with gene probabilities of putative causality (GPPC), model
posteriors (posterior_1, posterior_2, and posterior_12) and gene product
relevance probabilities (GPRP_1 and GPRP_2);
(2) EM algorithm prior parameter estimates;
(3) a Boolean indicating convergence of the EM algorithm.
}
\description{
Compute Multi-INTACT prior parameter estimates and gene product relevance
probabilities.
}
\examples{
data(multi_simdat)
multi_intact(df = multi_simdat)
}
