% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/makeSimModel-methods.R
\name{makeSimModel}
\alias{makeSimModel}
\alias{makeSimModel,INSPEcT-method}
\title{Build the synthetic rates shaped on a dataset}
\usage{
makeSimModel(
  object,
  nGenes,
  newTpts = NULL,
  probs = c(constant = 0.5, sigmoid = 0.3, impulse = 0.2),
  na.rm = TRUE,
  seed = NULL
)

\S4method{makeSimModel}{INSPEcT}(
  object,
  nGenes,
  probs = rbind(synthesis = c(constant = 0.5, sigmoid = 0.3, impulse = 0.2), processing
    = c(constant = 0.5, sigmoid = 0.3, impulse = 0.2), degradation = c(constant = 0.5,
    sigmoid = 0.3, impulse = 0.2)),
  na.rm = TRUE,
  seed = NULL
)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{nGenes}{A numeric with the number of synthtic genes to be created}

\item{newTpts}{A numeric verctor with time points of the synthtic dataset, if NULL the time points of the real dataset will be used}

\item{probs}{A numeric matrix wich describes the probability of each rate (rows) to be constant, shaped like a sigmoid or like an impulse model (columns)}

\item{na.rm}{A logical that set whether missing values in the real dataset should be removed}

\item{seed}{A numeric to obtain reproducible results}
}
\value{
An object of class INSPEcT_model with synthetic rates
}
\description{
This method allow the creation of synthesis, degradation and processing rates for a certain number of genes.
The rates are created according to the distributions of the real data-set which is given as an input of the
method. Different proportions of constant varying rates can be set and a new vector of time points can be
provided. This method has to be used before the \code{\link{makeSimDataset}} method.
}
\details{
The method \code{\link{makeSimModel}} generates an object of class INSPEcT_model that stores the parametric functions to genrate clean rates of a time-course. To any of the rates also a noise variance is associate but not used yet. In a typical workflow the output of \code{\link{makeSimModel}} is the input of the method \code{\link{makeSimDataset}}, that build the noisy rates and concentrations, given a specified number of replicates.
}
\examples{
nascentInspObj <- readRDS(system.file(package='INSPEcT', 'nascentInspObj.rds'))
simRates<-makeSimModel(nascentInspObj, 1000, seed=1)
table(geneClass(simRates))
}
\seealso{
\code{\link{makeSimDataset}}
}
