% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R,
%   R/makeOscillatorySimModel-methods.R
\name{makeOscillatorySimModel}
\alias{makeOscillatorySimModel}
\alias{makeOscillatorySimModel,INSPEcT-method}
\title{Build the synthetic rates with oscillatory pattern}
\usage{
makeOscillatorySimModel(
  object,
  nGenes,
  oscillatoryk3 = FALSE,
  k3delay = NULL,
  na.rm = TRUE,
  seed = NULL
)

\S4method{makeOscillatorySimModel}{INSPEcT}(
  object,
  nGenes,
  oscillatoryk3 = FALSE,
  k3delay = NULL,
  na.rm = TRUE,
  seed = NULL
)
}
\arguments{
\item{object}{An object of class INSPEcT}

\item{nGenes}{A numeric with the number of synthtic genes to be created}

\item{oscillatoryk3}{A logical that enables also degradation rate to oscillate}

\item{k3delay}{A numeric that set the delay between synthesis and degradation oscillations. When NULL, no coupling between the two oscillations is set.}

\item{na.rm}{A logical that set whether missing values in the real dataset should be removed}

\item{seed}{A numeric to obtain reproducible results}
}
\value{
An object of class INSPEcT_model with synthetic rates
}
\description{
This method allow the creation of synthesis, degradation and processing rates that generate
an oscillatory expression with a period of 24 hours. Two modes are available: one where 
oscillations arise just by oscillations in the synthesis of the genes (oscillatoryk3=FALSE, default) and
another one where both synthesis and degradation rates oscillates (oscillatoryk3=TRUE). In this latter case,
the oscillations of the two rates can be coupled by a cetrain delay (parametrer k3delay).
After the creation of the synthetic rates, a dataset with noise and contamination added can be made by \code{\link{makeSimDataset}}.
}
\examples{
nascentInspObj <- readRDS(system.file(package='INSPEcT', 'nascentInspObj.rds'))
simRates<-makeOscillatorySimModel(nascentInspObj, 1000, seed=1)
table(geneClass(simRates))
}
\seealso{
\code{\link{makeSimModel}}
}
