% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoreMethods.R
\name{VlnPlot}
\alias{VlnPlot}
\alias{VlnPlot.SingleCellExperiment}
\alias{VlnPlot,SingleCellExperiment-method}
\title{Gene expression visualization using violin plots}
\usage{
VlnPlot.SingleCellExperiment(
  object,
  clustering.type,
  genes,
  return.plot,
  rotate.x.axis.labels
)

\S4method{VlnPlot}{SingleCellExperiment}(
  object,
  clustering.type = "manual",
  genes = NULL,
  return.plot = FALSE,
  rotate.x.axis.labels = FALSE
)
}
\arguments{
\item{object}{of \code{SingleCellExperiment} class}

\item{clustering.type}{"manual" or "optimal". "manual"
refers to the clustering formed using the "SelectKClusters" function
and "optimal" to the clustering formed using the
"CalcSilhInfo" function. Default is "manual".}

\item{genes}{a character vector denoting the gene names that are visualized}

\item{return.plot}{return.plot whether to return the ggplot2 object}

\item{rotate.x.axis.labels}{a logical denoting whether the x-axis
labels should be rotated 90 degrees.
or just draw it. Default is \code{FALSE}.}
}
\value{
ggplot2 object if return.plot=TRUE
}
\description{
The VlnPlot function enables visualizing expression levels of a gene,
or multiple genes, across clusters using Violin plots.
}
\examples{
library(SingleCellExperiment)
sce <- SingleCellExperiment(assays = list(logcounts = pbmc3k_500))
sce <- PrepareILoReg(sce)
## These settings are just to accelerate the example, use the defaults.
sce <- RunParallelICP(sce,L=2,threads=1,C=0.1,k=5,r=1)
sce <- RunPCA(sce,p=5)
sce <- HierarchicalClustering(sce)
sce <- SelectKClusters(sce,K=5)
VlnPlot(sce,genes=c("CD3D","CD79A","CST3"))

}
\keyword{plot}
\keyword{violin}
