% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_pkg.R
\name{create_pkg}
\alias{create_pkg}
\title{Create a Bioconductor Hub package}
\usage{
create_pkg(package, type = c("AnnotationHub", "ExperimentHub"), use_git = TRUE)
}
\arguments{
\item{package}{A \code{character(1)} with the path of the package to be created.}

\item{type}{A \code{character(1)} to indicate what type of hub package is to be
created. Either \code{AnnotationHub} or \code{ExperimentHub} are acceptable.}

\item{use_git}{A \code{logical(1)} indicating whether to set up \code{git} using
\code{usethis::use_git()}. Default is set to TRUE.}
}
\value{
Path to package location
}
\description{
This function creates the skeleton of a package that follow the guidelines
for Bioconductor type packages. It is expected of the user to go through and
make any necessary changes or improvements once the package begins to take
shape. For examples, the DESCRIPTION contains very basic requirements, but
the developer should go back and fill in the 'Title:' and 'Description:'
fields.
}
\examples{
fl <- tempdir()
create_pkg(file.path(fl, "tstPkg"), "AnnotationHub")

}
