% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doQuery.R
\name{doQuery}
\alias{doQuery}
\title{Search HoloFood database for animals, genome catalogues, samples,
or viral catalogues}
\usage{
doQuery(type, flatten = TRUE, ...)
}
\arguments{
\item{type}{\code{Character scalar} specifying the type of data to
query. Must be one of the following options: \code{"animals"},
\code{"genome-catalogues"}, \code{"samples"} or \code{"viral-catalogues"}.}

\item{flatten}{\code{Logical scalar} specifying whether to flatten the
resulting \code{data.frame}. This means that columns with multiple values
are separated to multiple columns. (Default: \code{TRUE})}

\item{...}{optional arguments:
\itemize{

  \item \strong{max.hits} \code{NULL} or \code{integer scalar} specifying the
  maximum number of results to fetch. When NULL, all results are fetched.
  (Default: \code{NULL})
  
  \item \strong{spread.sample.types} \code{Logical scalar} specifying whether
  to create spread sample types column of animals data. In animals data,
  sample types column might have multiple values that might be hard to
  explore. This argument specifies whether to create presence/absence table
  from sample types. (Default: \code{TRUE})
  
  \item \strong{use.cache} \code{Logical scalar} specifying whether to
  use cache. (Default: \code{FALSE})
  
  \item \strong{cache.dir} \code{Character scalar} specifying cache
  directory. (Default: \code{tempdir()})
  
  \item \strong{clear.cache} \code{Logical scalar} specifying whether to
  remove and clear cache (Default: \code{FALSE})
  
}}
}
\value{
\code{data.frame}
}
\description{
Search HoloFood database for animals, genome catalogues, samples,
or viral catalogues
}
\details{
\code{doQuery} is a flexible query function which can be utilized to search
available animals, genome catalogues, samples, or viral catalogues. Search
results can be filtered; for example, animals can be filtered based on
available samples. See [Api browser](https://www.holofooddata.org/api/docs)
for information on filters. You can find help on customizing queries from
[here](https://emg-docs.readthedocs.io/en/latest/api.html#customising-queries).
}
\examples{

# Find animals results. The maximum amount of results is 100. Use filter
# so that only chicken is searched. (See details on customizing queries)
res <- doQuery("animals", max.hits = 100, system = "chicken")
head(res)

}
