% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggAPA.R
\name{ggAPA}
\alias{ggAPA}
\title{Aggregation plot}
\usage{
ggAPA(
  aggregatedMtx = NULL,
  title = NULL,
  trim = 0,
  tails = "both",
  colMin = NULL,
  colMid = NULL,
  colMax = NULL,
  colBreaks = NULL,
  blurPass = 0,
  boxKernel = NULL,
  kernSize = NULL,
  stdev = 0.5,
  loTri = NULL,
  colors = NULL,
  na.value = "#F2F2F2",
  colorScale = "linear",
  bias = 1,
  paletteLength = 51,
  annotate = TRUE,
  anchor.name = "Anchor",
  bait.name = "Bait",
  fixCoord = TRUE
)
}
\arguments{
\item{aggregatedMtx}{\if{html}{\out{<matrix>}} : The matrix to plot.
(Default NULL)}

\item{title}{\if{html}{\out{<character>}} : The title of plot.
(Default NULL)}

\item{trim}{\if{html}{\out{<numeric>}} : A number between 0 and 100
that gives the percentage of trimming. (Default 0)}

\item{tails}{\if{html}{\out{<character>}} : Which boundary must be trimmed?
If it's both, trim half of the percentage in inferior and superior.
see \code{QtlThreshold}. (Default "both")}

\item{colMin}{\if{html}{\out{<numeric>}} : Minimal value of Heatmap,
force color range. If \code{NULL} automatically find. (Default NULL)}

\item{colMid}{\if{html}{\out{<numeric>}} : Center value of Heatmap,
force color range. If \code{NULL} automatically find. (Default NULL)}

\item{colMax}{\if{html}{\out{<numeric>}} : Maximal value of Heatmap,
force color range. If \code{NULL} automatically find. (Default NULL)}

\item{colBreaks}{\if{html}{\out{<numeric>}} : Repartition of colors.
If \code{NULL} automatically find. (Default NULL)}

\item{blurPass}{\if{html}{\out{<numeric>}} : Number of blur pass. (Default 0)}

\item{boxKernel}{\if{html}{\out{<numeric>}} : If \code{NULL} automatically
compute for 3 Sd. (Default NULL)}

\item{kernSize}{\if{html}{\out{<numeric>}} : Size of box applied to blurr.
If \code{NULL} automatically compute for 3 Sd. (Default NULL)}

\item{stdev}{\if{html}{\out{<numeric>}} : SD of gaussian smooth. (Default 0.5)}

\item{loTri}{\if{html}{\out{<numeric>}} : The value that replace all value in
the lower triangle of matrice (Usefull when blur is apply).(Default NULL)}

\item{colors}{\if{html}{\out{<character>}} : Heatmap color list.
If \code{NULL}, automatically compute. (Default NULL)}

\item{na.value}{\if{html}{\out{<character>}} : Color of NA values.
(Default "#F2F2F2")}

\item{colorScale}{\if{html}{\out{<character>}} : Shape of color scale on of
"linear" or "density" based. (Default "linear")}

\item{bias}{\if{html}{\out{<numeric>}} : A positive number. Higher values give
more widely spaced colors at the high end. See \code{?grDevices::colorRamp}
for more details. (Default 1)}

\item{paletteLength}{\if{html}{\out{<numeric>}} : The number of color in the
palette. (Default 51)}

\item{annotate}{\if{html}{\out{<logical>}} : Should there be axis ticks?
(Default: TRUE)}

\item{anchor.name}{\if{html}{\out{<character>}} Name of anchor for
annotation. (Default "Anchor")}

\item{bait.name}{\if{html}{\out{<character>}} Name of bait for
annotation. (Default "Bait")}

\item{fixCoord}{\if{html}{\out{<logical>}} Fix axes coordinates?
(Default TRUE)}
}
\value{
A ggplot object.
}
\description{
Create a ggplot object used for plot aggregation.
}
\details{
ggAPA
}
\examples{
# Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)

# Index Beaf32
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] 
# subset 2000 first for exemple

# Matrices extractions center on Beaf32 <-> Beaf32 point interaction
interactions_PF.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)

# Aggregate matrices in one matrix
aggreg.mtx <- Aggregation(interactions_PF.mtx_lst)

# Visualization
ggAPA(
    aggregatedMtx = aggreg.mtx
)

# Add Title
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA"
)

# Trim values
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA 30\% trimmed on upper tail of distribution",
    trim = 30,
    tails = "upper"
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA 30\% trimmed on lower tail of distribution",
    trim = 30,
    tails = "lower"
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA 15\% trimmed on each tail of distribution",
    trim = 30,
    tails = "both"
)

# Change Minimal, Central and Maximal Colors scale value
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA [min 200, center 300, max 600]",
    colMin = 200,
    colMid = 300,
    colMax = 600
)

# Change Color
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    colors = viridis(6),
    na.value = "black"
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    colors = c("black", "white"),
)

# Change Color distribution
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA [100,150,200,250,300,350,600]",
    colBreaks = c(100, 150, 200, 250, 300, 350, 600) # Choosen Breaks
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    colorScale = "density" # color distribution based on density
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    bias = 2 # (>1 wait on extremums)
)
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    bias = 0.5 # (<1 wait on center)
)

# Apply a Blurr
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
    blurPass = 1,
    stdev = 0.5
)

# ggplot2 object modifications
# Since the function returns a ggplot object, it is possible
# to modify it following the ggplot2 grammar.
ggAPA(
    aggregatedMtx = aggreg.mtx,
    title = "APA",
) +
    ggplot2::labs(
        title = "New title",
        subtitle = "and subtitle"
    )
}
