% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OrientateMatrix.R
\name{OrientateMatrix}
\alias{OrientateMatrix}
\title{Matrix orientation}
\usage{
OrientateMatrix(mtx, verbose = TRUE)
}
\arguments{
\item{mtx}{<matrix or List\link{matrix}>: Matrix or matricies list
to oriente}

\item{verbose}{\if{html}{\out{<logical>}}: Report the number of matrices
corrected. (Default: TRUE)}
}
\value{
Oriented matrix or matricies list
}
\description{
Oriente extracted Matrix according to the anchors and bait
order. Apply a 180° rotation follow with a transposation on a matrix or
on matrices in a list according to the interactions attributes of the list.
}
\details{
OrientateMatrix
}
\examples{
# Data
data(Beaf32_Peaks.gnr)
data(HiC_Ctrl.cmx_lst)

# Index Beaf32 in TADs domains
Beaf32_Index.gnr <- IndexFeatures(
    gRangeList = list(Beaf = Beaf32_Peaks.gnr),
    chromSizes = data.frame(
        seqnames = c("2L", "2R"),
        seqlengths = c(23513712, 25286936)
    ),
    binSize = 100000
)

# Beaf32 <-> Beaf32 Pairing
Beaf_Beaf.gni <- SearchPairs(indexAnchor = Beaf32_Index.gnr)
Beaf_Beaf.gni <- Beaf_Beaf.gni[seq_len(2000)] # subset 2000 first for exemple

# Matrices extractions center on Beaf32 <-> Beaf32 point interaction
interactions_PF.mtx_lst <- ExtractSubmatrix(
    genomicFeature = Beaf_Beaf.gni,
    hicLst = HiC_Ctrl.cmx_lst,
    referencePoint = "pf"
)

# Matrices Orientation
oriented_Interactions_PF.mtx_lst <- OrientateMatrix(interactions_PF.mtx_lst)

}
