% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinGRanges.R
\name{BinGRanges}
\alias{BinGRanges}
\title{Bin a GRanges.}
\usage{
BinGRanges(
  gRange = NULL,
  chromSizes = NULL,
  binSize = NULL,
  method = "mean",
  metadataColName = NULL,
  na.rm = TRUE,
  cores = 1,
  reduceRanges = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{gRange}{\if{html}{\out{<GRanges>}}: A GRanges to bin.}

\item{chromSizes}{<data.frame>: A data.frame
where first colum corresponds to the chromosomes names,
and the second column corresponds to the chromosomes lengths in base pairs.}

\item{binSize}{\if{html}{\out{<numerical>}}: Width of the bins.}

\item{method}{\if{html}{\out{<character>}}: Name of a summary method
as 'mean', 'median', 'sum', 'max, 'min'. (Default 'mean')}

\item{metadataColName}{\if{html}{\out{<character>}} : A character vector
that specify the metadata columns of GRanges on which
to apply the summary method.}

\item{na.rm}{\if{html}{\out{<logical>}} : A logical value indicating
whether \code{NA} values should be stripped before the computation proceeds.
(Default TRUE)}

\item{cores}{\if{html}{\out{<numerical>}} : The number of cores. (Default 1)}

\item{reduceRanges}{\if{html}{\out{<logical>}} : Whether duplicated Bins must
be reduced with the summary method (\code{method} arg). (Default TRUE)}

\item{verbose}{\if{html}{\out{<logical>}}: If TRUE,
show the progression in console. (Default FALSE)}
}
\value{
A binned GRanges.
}
\description{
Bin a GRanges and apply a summary method (e.g: 'mean',
'median', 'sum', 'max, 'min' ...) to a chosen numerical variable of ranges
in the same bin.
}
\details{
BinGRanges
}
\examples{
GRange.gnr <- GenomicRanges::GRanges(
    seqnames = S4Vectors::Rle(c("chr1", "chr2"), c(3, 1)),
    ranges = IRanges::IRanges(
        start = c(1, 201, 251, 1),
        end = c(200, 250, 330, 100),
        names = letters[seq_len(4)]
    ),
    strand = S4Vectors::Rle(BiocGenerics::strand(c("*")), 4),
    score = c(50, NA, 100, 30)
)
GRange.gnr
BinGRanges(
    gRange = GRange.gnr,
    chromSizes = data.frame(c("chr1", "chr2"), c(350, 100)),
    binSize = 100,
    method = "mean",
    metadataColName = "score",
    na.rm = TRUE
)

}
