% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coolParser.R
\name{parseCool}
\alias{parseCool}
\title{Parser for data in cool format}
\usage{
parseCool(paths, binSize = NA, conditions, replicates)
}
\arguments{
\item{paths}{A vector of paths to \code{.cool} or \code{.mcool} files.}

\item{binSize}{The resolution (span of each position in number of bases). Optionally
provided to select the appropriate resolution in \code{.mcool} files.
Defaults to NULL.}

\item{conditions}{A vector of condition names repeated along the replicates.}

\item{replicates}{A vector of replicate names repeated along the conditions.}
}
\value{
An InteractionSet.
}
\description{
Parses interactions in \code{.cool} or \code{.mcool} format and returns
an InteractionSet object.
}
\details{
To read \code{.cool} of \code{.mcool} files, the \code{rhdf5} package is required.
Please install it before running the function.
}
\examples{
# EXAMPLE FOR .cool FORMAT
# Path to each file
pathsCool <- c(
    "path/to/condition-1.replicate-1.cool",
    "path/to/condition-1.replicate-2.cool",
    "path/to/condition-1.replicate-3.cool",
    "path/to/condition-2.replicate-1.cool",
    "path/to/condition-2.replicate-2.cool",
    "path/to/condition-2.replicate-3.cool"
)
# Condition and replicate of each file. Can be names instead of numbers.
conditions <- c(1, 1, 1, 2, 2, 2)
replicates <- c(1, 2, 3, 1, 2, 3)
if (FALSE) {
    library(rhdf5)
    object <- parseCool(
        paths,
        conditions = conditions,
        replicates = replicates
    )
}

# EXAMPLE FOR .mcool FORMAT
# Resolution
binSize <- 500000
# Path to each file
paths <- c(
    "path/to/condition-1.replicate-1.mcool",
    "path/to/condition-1.replicate-2.mcool",
    "path/to/condition-1.replicate-3.mcool",
    "path/to/condition-2.replicate-1.mcool",
    "path/to/condition-2.replicate-2.mcool",
    "path/to/condition-2.replicate-3.mcool"
)
# Condition and replicate of each file. Can be names instead of numbers.
conditions <- c(1, 1, 1, 2, 2, 2)
replicates <- c(1, 2, 3, 1, 2, 3)
if (FALSE) {
    # Instantiation of data set
    library(rhdf5)
    object <- parseCool(
        paths,
        conditions = conditions,
        replicates = replicates,
        binSize = binSize
    )
}
}
