% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HicFile-class.R, R/HicFile-methods.R
\name{HicFile-class}
\alias{HicFile-class}
\alias{HicFile}
\alias{HicFile-methods}
\alias{show,HicFile-method}
\title{\code{HicFile} S4 class}
\arguments{
\item{path}{String; path to a .hic file}

\item{resolution}{numeric; resolution to use with mcool file}

\item{pairsFile}{String; path to a pairs file}

\item{metadata}{list.}

\item{object}{A \code{HicFile} object.}
}
\description{
The \code{HicFile} class describes a \code{BiocFile} object, pointing to the location
of a .hic file (usually created with juicer) and containing 3
additional slots:
\enumerate{
\item resolution: at which resolution the associated .hic file should be parsed;
\item pairsFile: the path (in plain character) to an optional pairs file
(stored as a \code{PairsFile} object);
\item metadata: a list metadata
}

HicFile methods.
}
\examples{
hicPath <- HiContactsData::HiContactsData('yeast_wt', 'hic')
pairsPath <- HiContactsData::HiContactsData('yeast_wt', 'pairs.gz')
hic <- HicFile(
  hicPath, 
  resolution = 16000, 
  pairsFile = pairsPath, 
  metadata = list(type = 'example')
)
hic
resolution(hic)
pairsFile(hic)
metadata(hic)
}
\seealso{
\code{\link[=CoolFile]{CoolFile()}}, \code{\link[=HicproFile]{HicproFile()}}
}
