% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_list_read.R
\name{gi_list_read}
\alias{gi_list_read}
\title{gi_list_read}
\usage{
gi_list_read(
  fname,
  chrs = NULL,
  Dthreshold = NULL,
  features = NULL,
  gen = "Hsapiens",
  gen_ver = "hg19"
)
}
\arguments{
\item{fname}{path to the file to read from (can end with .txt,
.rds, or .txt.gz).}

\item{chrs}{select a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes contained in the \code{fname}.}

\item{Dthreshold}{maximum distance (included) to check for significant
interactions, defaults to the maximum in the data.}

\item{features}{Select the subset of features (1-D or 2-D) to be added to the
gi_list instance (without the trailing I or J),
defaults to all features (score column gets ingested as 'score').}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}}
}
\value{
A valid gi_list instance with 1D features stored in regions metadata
handle of each list element (e.g., 
\code{gi_list[[1]]@regions@elementMetadata}) in the instance and with 2D 
features stored in metadata handle
(i.e., \code{mcols(gi)}).
}
\description{
Reads a written gi_list instance using \code{gi_list_write} into a valid
gi_list instance.
}
\examples{
outputdir<-paste0(tempdir(check=TRUE),'/')
gi_list<-generate_binned_gi_list(1e6,chrs='chr22')
gi_list_write(gi_list,paste0(outputdir,'testgiread.txt'))
gi_list2<-gi_list_read(paste0(outputdir,'testgiread.txt'))
}
