% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_binned_gi_list.R
\name{generate_binned_gi_list}
\alias{generate_binned_gi_list}
\title{generate_binned_gi_list}
\usage{
generate_binned_gi_list(
  binsize,
  chrs = NULL,
  Dthreshold = 2e+06,
  gen = "Hsapiens",
  gen_ver = "hg19"
)
}
\arguments{
\item{binsize}{Desired binsize in bp, e.g., 5000, 25000.}

\item{chrs}{a subset of chromosomes' e.g.,
c('chr21','chr22'). Defaults to all chromosomes except "Y", and "M" for
the specified \code{gen} and \code{gen_ver}.}

\item{Dthreshold}{maximum distance (included) to check for significant
interactions, defaults to 2e6 or maximum in the data; whichever is smaller.}

\item{gen}{name of the species: e.g., default \code{'Hsapiens'}.}

\item{gen_ver}{genomic assembly version: e.g., default \code{'hg19'}.}
}
\value{
a valid, uniformly binned gi_list instance.
}
\description{
Generates a valid uniformly binned gi_list instance.
}
\examples{
gi_list<-generate_binned_gi_list(1e6,chrs='chr22')
}
