% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annHeatmap.R
\name{picketPlot}
\alias{picketPlot}
\title{Display a data frame of annotation information}
\usage{
picketPlot(
  x,
  grp = NULL,
  grpcol,
  grplabel = NULL,
  horizontal = TRUE,
  asIs = FALSE,
  control = list()
)
}
\arguments{
\item{x}{usually a data frame, which is passed to \code{convAnnData} to be
converted to a numerical matrix with dummy coding for the factor levels.
Alternatively, such a numerical matrix can be constructed manually and
passed in as \code{x}, see argument \code{asIs}}

\item{grp}{an optional vector of cluster memberships, in the same order as
the rows of \code{x}}

\item{grpcol}{an optional vector of background colors for the clusters
specified in \code{grp}}

\item{grplabel}{an optional vector of names for the clusters specified in
\code{grp}}

\item{horizontal}{logical value whether to plot variables horizontally
(default) or vertically}

\item{asIs}{a logical value indicating whether \code{x} should be passed to
\code{convAnnData} for pre-processing or not. Defaults to \code{FALSE}.}

\item{control}{a named list of control parameters that determines the visual 
appearance of the plot; see \code{picketPlotControl} for details.}
}
\value{
Invisibly, a list containing the data and parameters used for plotting
each binary indicator and numerical variable, respectively. This is an internal
data structure, mostly useful for debugging. Irrelevant, as the main desired
effetc is a plot to the current graphical device.
}
\description{
Displays a data frame of both factor and numerical variables in parallel
panels. Factors levels are indicated by black rectangles, using dummy
variables for more than two levels. Numerical variables are shown as simple
index plots with an optional loess smoother. Panels can be arranged
horizontally or vertically, and different groups of subjects can be
indicated through different background colors.
}
\details{
Missing values are indicated by a box marking in \code{nacol} for factor
values.
}
\examples{

    ## Standard call
    data(mtcars)
    picketPlot(mtcars)
    
    ## Pre-process the data for display
    mm = convAnnData(mtcars, inclRef=FALSE)
    picketPlot(mm, asIs=TRUE)
    
    ## Higher panels for continous traits
    picketPlot(mm, asIs=TRUE, control=list(numfac=3))
 
    ## With clusters
    picketPlot(mtcars, grp = rep(1:2, c(16, 16)), grpcol = c("pink","lightblue"), grplabel=c("Cluster 1", "Cluster 2"))

}
\seealso{
\code{\link{annHeatmap2}}, \code{\link{convAnnData}},
\code{\link{par}}, \code{\link{picketPlotControl}}
}
\keyword{hplot}
