% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichfind_hp.R
\name{enrichfind_hp}
\alias{enrichfind_hp}
\title{Functional Enrichment Analysis of all Host Proteins}
\usage{
enrichfind_hp(
  ppi,
  threshold = 0.05,
  sources = c("GO", "KEGG"),
  p.corrction.method = "bonferroni",
  org = "hsapiens"
)
}
\arguments{
\item{ppi}{A data.frame containing pathogen proteins in the
first column and host proteins in the second column.}

\item{threshold}{Custom p-value threshold for significance.}

\item{sources}{A vector of data sources to use.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{p.corrction.method}{The algorithm used for multiple testing
correction;defaults to 'bonferroni'.
See \code{\link[gprofiler2]{gost}} for more details.}

\item{org}{An organism name;defaults to 'hsapiens'.
See \code{\link[gprofiler2]{gost}} for more details.}
}
\value{
A data.frame with the enrichment analysis results.
}
\description{
This function uses \code{\link[gprofiler2]{gost}} function
in \code{gprofiler2} package to perfrom functional enrichment analysis
for all predicted host proteins in the high-confidence network.
}
\details{
enrichfind_hp
}
\examples{
data('predicted_PPIs')
#perform enrichment
enrich.df <- enrichfind_hp(predicted_PPIs,
threshold = 0.05,
sources = c("GO", "KEGG"),
p.corrction.method = "bonferroni",
org = "hsapiens")
}
\seealso{
See \code{\link{enrichplot}} for plotting enrichment analysis.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
