% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getHPI.R
\name{getHPI}
\alias{getHPI}
\title{Generating Host-Pathogen Protein-Protein Interaction (HP-PPI)
Descriptors}
\usage{
getHPI(pathogenData, hostData, type = c("combine", "kron.prod"))
}
\arguments{
\item{pathogenData}{The pathogen descriptor matrix.}

\item{hostData}{The host descriptor matrix.}

\item{type}{The interaction type, one or two of
\code{"combine"} and \code{"kron.prod"}.}
}
\value{
A matrix containing the Host-Pathogen Protein-Protein Interaction
(HP-PPI) descriptors.
}
\description{
This function calculates Host-Pathogen Protein-Protein
Interaction (HP-PPI) descriptors via two approaches
\itemize{
\item \code{combine} - combine the two descriptor matrix,
result has \code{(p1 + p2)} columns
\item \code{kron.prod} - if A has m x n matrix and B is q x p matrix,
then the Kronecker product is the code{(pm × qn)} block matrix
}
}
\details{
getHPI
}
\examples{
x <- matrix(c(1, 2, 3, 1), nrow = 2, ncol = 2, byrow = TRUE)
y <- matrix(c(0, 3, 2, 1), nrow = 2, ncol = 2, byrow = TRUE)
getHPI(x, y, "combine")
getHPI(x, y, "kron.prod")
}
\author{
Matineh Rahmatbakhsh \email{matinerb.94@gmail.com}
}
