% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_missing_values.R
\name{filter_missing_values}
\alias{filter_missing_values}
\title{Drop the Missing Values Above a Certain Threshold}
\usage{
filter_missing_values(x, max_miss_rate = 20)
}
\arguments{
\item{x}{A numeric matrix as input.}

\item{max_miss_rate}{Maximal missing rate allowed for a feature;default
is 20.}
}
\value{
A dataframe with features with missingness rate of more than
user-defined threshold.
}
\description{
Given an input matrix, compute the missingness rate for
each features and keep only features with missing rate more than
user-defined percentage.
}
\details{
filter_missing_values
}
\examples{
x <- matrix(1:10, ncol = 2)
x[, 2] <- NA
filter_missing_values(x, 30)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
