% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_plot.R
\name{corr_plot}
\alias{corr_plot}
\title{Plot Correlation Matrix between Input Features}
\usage{
corr_plot(cormat, method = "number", cex = 0.9)
}
\arguments{
\item{cormat}{A correlation matrix.}

\item{method}{The visualization method of correlation matrix;
defaults to number.
See \code{\link[corrplot]{corrplot}} for more details.}

\item{cex}{The size of x/y axis label.}
}
\value{
A correlation plot.
}
\description{
A graphical display of a correlation matrix.
}
\details{
corr_plot
}
\examples{
data('example_data')
x <- na.omit(example_data)
#perform feature selection
s <- FSmethod(x, type = 'both',
cor.cutoff = 0.7, resampling.method = "repeatedcv",
iter = 5, repeats = 3, metric = "ROC", verbose = TRUE)
corr_plot(s$cor.result$corProfile, method = 'square' , cex = 0.5)
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}.
}
