% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateDC.R
\name{calculateDC}
\alias{calculateDC}
\title{Calculate Dipeptide Composition (DC) Descriptor}
\usage{
calculateDC(x)
}
\arguments{
\item{x}{A data.frame containing gene/protein names and their fasta
sequences.}
}
\value{
A length 400 named vector for the data input.
}
\description{
This function calculates Dipeptide Composition (DC)
descriptor for data input.
}
\details{
calculateDC
}
\examples{
data(UP000464024_df)
x_df <- calculateDC(UP000464024_df)
head(x_df, n = 2L)
}
\references{
Bhasin, M., and Raghava, G. P. S. (2004).
Classification of nuclear receptors based on amino acid composition
and dipeptide composition. \emph{J. Biol. Chem.} 279, 23262–23266.
}
\seealso{
See \code{\link{calculateAAC}} and \code{\link{calculateTC}}
for Amino Acid Composition and Tripeptide Composition descriptors.
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
