% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{hpaVisPatho}
\alias{hpaVisPatho}
\title{Visualize pathology data}
\usage{
hpaVisPatho(
  data = NULL,
  targetGene = NULL,
  targetCancer = NULL,
  facetBy = "cancer",
  color = c("#FCFDBF", "#FE9F6D", "#DE4968", "#8C2981"),
  customTheme = FALSE
)
}
\arguments{
\item{data}{Input the list object generated by \code{hpa_download()} or
\code{hpa_subset()}. Require the \code{pathology} dataset. Use HPA
histology data (built-in) by default.}

\item{targetGene}{Vector of strings of HGNC gene symbols. By default it is
set to \code{c('TP53', 'EGFR', 'CD44', 'PTEN')}. You can also mix HGNC gene
symbols and ensemnl ids (start with ENSG) and they will be converted to
HGNC gene symbols.}

\item{targetCancer}{Vector of strings of normal tissues. The function will
plot all available cancer by default.}

\item{facetBy}{Determine how multiple graphs would be faceted. Either
\code{cancer} (default) or \code{gene}.}

\item{color}{Vector of 4 colors used to depict different expression levels.}

\item{customTheme}{Logical argument. If \code{TRUE}, the function will return
a barebone ggplot2 plot to be customized further.}
}
\value{
This function will return a ggplot2 plot object, which can be further
  modified if desirable. The pathology data is visualized as multiple bar
  graphs, one for each type of cancer. For each bar graph, x axis contains
  the inquired protein and y axis contains the proportion of patients.
}
\description{
Visualize the expression of genes of interest in each cancer.
}
\examples{
  data("hpa_histology_data")
  geneList <- c('TP53', 'EGFR', 'CD44', 'PTEN', 'IDH1', 'IDH2', 'CYCS')
  cancerList <- c('breast cancer', 'glioma', 'melanoma')

  ## A typical function call
  hpaVisPatho(data=hpa_histology_data,
                 targetGene=geneList)

}
\seealso{
Other visualization functions: 
\code{\link{hpaVis}()},
\code{\link{hpaVisSubcell}()},
\code{\link{hpaVisTissue}()}
}
\concept{visualization functions}
