% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{hpaDownload}
\alias{hpaDownload}
\title{Download datasets}
\usage{
hpaDownload(downloadList = "histology", version = "latest")
}
\arguments{
\item{downloadList}{A vector or string indicate which datasets to download.
  Common values:
  \itemize{
    \item \code{'normal_tissue'}
    \item \code{'pathology'}
    \item \code{'subcellular_location'}
    }
  For the full list of possible values for a specific version, set
  downloadList as NULL: \code{hpaDownload(downloadList = NULL, version =
  <version>)}

  You can also use the following shortcuts:
  \itemize{
    \item \code{'all'}: download everything (not recommended!!!)
    \item \code{'histology'}: same as \code{c('normal_tissue', 'pathology',
    'subcellular_location')}
  }
  See \url{https://www.proteinatlas.org/about/download} for more information.}

\item{version}{A string indicate which version to be downloaded. Possible
value:
\itemize{
  \item \code{'latest'}: Download latest version. Due to the constantly
  changing nature of the API, this will download the latest version known
  to work with this package. Require Internet connection. This is the
  default option.
  \item \code{'example'} or \code{'built-in'}: Load the built-in histology
  dataset from 'HPAanalyze' ('hpa_histology_data'). Do not require internet
  connection.
  \item \code{'v23'}: version 23
  \item \code{'v24'}: version 24
}}
}
\value{
This function will return a list of tibbles corresponding to
  requested datasets.
}
\description{
Download the latest version of HPA datasets and import them in R. It is
recommended to only download the datasets you need, as some of them may be
very big.
}
\examples{
  histologyData <- hpaDownload(downloadList='histology', version='example')
  # tissueTranscriptData <- hpaDownload('RNA transcript tissue')

}
\seealso{
\code{\link{hpaDownload}} \code{\link{hpa_histology_data}}

Other downloadable datasets functions: 
\code{\link{hpaExport}()},
\code{\link{hpaSubset}()}
}
\concept{downloadable datasets functions}
