% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitope_finding.R
\name{findEpitopeSegments}
\alias{findEpitopeSegments}
\title{Find Epitopes from probe stats and calls.}
\usage{
findEpitopeSegments(
  PDS_obj,
  segment_method = "unique",
  segment_score_type = "binary",
  segment_dist_method = "hamming",
  segment_cutoff = "silhouette"
)
}
\arguments{
\item{PDS_obj}{HERONProbeDataSet with pvalues and calls in the assay}

\item{segment_method}{which epitope finding method to use
(binary or zscore, applies for hclust or skater)}

\item{segment_score_type}{which type of scoring to use for probes}

\item{segment_dist_method}{what kind of distance score method to use}

\item{segment_cutoff}{for clustering methods, what cutoff to use
(either numeric value or 'silhouette')}
}
\value{
a vector of epitope identifiers or segments found
}
\description{
Find Epitopes from probe stats and calls.
}
\examples{
data(heffron2021_wuhan)
seq_pval_res <- calcCombPValues(heffron2021_wuhan)
pr_pval_res <- convertSequenceDSToProbeDS(seq_pval_res)
pr_calls_res <- makeProbeCalls(pr_pval_res)
segments_res <- findEpitopeSegments(pr_calls_res)
}
