% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcProbePvaluesT.R
\name{calcProbePValuesTPaired}
\alias{calcProbePValuesTPaired}
\title{Calculate Probe p-values using a differential paired t-test}
\usage{
calcProbePValuesTPaired(
  probe_mat,
  colData_in,
  sd_shift = NA,
  abs_shift = NA,
  debug = FALSE
)
}
\arguments{
\item{probe_mat}{numeric matrix or data.frame of values}

\item{colData_in}{design data.frame}

\item{sd_shift}{standard deviation shift to use when calculating p-values.
Either sd_shift or abs_shift should be set}

\item{abs_shift}{absolute shift to use when calculating p-values.}

\item{debug}{print debugging information}
}
\value{
matrix of p-values on the post columns defined in the colData matrix.
Attributes of the matrix are:

pars - data.frame parameters used in the paired t-test for each row
(e.g. df, sd)

mapping - data.frame of mapping used for pre-post column calculation
diff_mat - data.frame
containing the post-pre differences for each sample (column) and probe (row)
}
\description{
Calculate Probe p-values using a differential paired t-test
}
\examples{
data(heffron2021_wuhan)
colData_wu <- colData(heffron2021_wuhan)
pre_idx = which(colData_wu$visit == "pre")
## Make some samples paired
colData_post = colData_wu[colData_wu$visit == "post",]
new_ids = rownames(colData_post)[seq_len(5)]
colData_wu$ptid[pre_idx[seq_len(5)]] = new_ids
exprs <- assay(heffron2021_wuhan, "exprs")
pval_res <- calcProbePValuesTPaired(exprs, colData_wu)
}
