% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaVolcano.R
\name{glimmaVolcano.DGEExact}
\alias{glimmaVolcano.DGEExact}
\title{Glimma Volcano Plot}
\usage{
\method{glimmaVolcano}{DGEExact}(
  x,
  dge = NULL,
  counts = dge$counts,
  groups = dge$samples$group,
  status = edgeR::decideTests.DGEExact(x),
  anno = x$genes,
  display.columns = NULL,
  status.cols = c("#1052bd", "silver", "#cc212f"),
  sample.cols = NULL,
  p.adj.method = "BH",
  transform.counts = c("logcpm", "cpm", "rpkm", "none"),
  main = paste(x$comparison[2], "vs", x$comparison[1]),
  xlab = "logFC",
  ylab = "negLog10PValue",
  html = NULL,
  width = 920,
  height = 920,
  ...
)
}
\arguments{
\item{x}{DGEExact object from which summary statistics are extracted from to create summary (left) plot.}

\item{dge}{\code{DGEList} object with \code{nrow(x)} rows from which expression values are
extracted from to create expression (right) plot. Gene counts are taken from \code{dge$counts}
and sample groups from \code{dge$samples$group}. By default raw counts are transformed to
log-cpm values (see more in the \code{transform.counts} argument).}

\item{counts}{numeric matrix with \code{nrow(x)} rows containing gene expression values.
This can be used to replace the gene counts from \code{dge$counts}, i.e. you may have
log-rpkm values stored in a different object that you wish to use.}

\item{groups}{vector of length \code{ncol(dge)} representing categorisation of samples in
expression plot.}

\item{status}{vector of length nrow(x) indicating the status of each gene. By default genes in the summary plot are
coloured based on its differential expression status using an adjusted p-value cutoff of 0.05
by calling the \code{edgeR::decideTests()} function, where the value of -1 marks down-regulated genes, 0 marks genes with no
expression difference, and 1 marks up-regulated genes.}

\item{anno}{dataframe with \code{nrow(x)} rows containing gene annotations.}

\item{display.columns}{character vector containing names of columns from \code{anno} from
which to display in mouseover tooltips and table.}

\item{status.cols}{vector of length 3 containing valid CSS strings for colours associated
with \code{status}  in the order of -1, 0 and 1.}

\item{sample.cols}{character vector of length \code{ncol(counts)} containing valid CSS strings
for colours associated with each sample to be displayed on the expression plot. If left
unspecified, samples will be coloured according to \code{groups}.}

\item{p.adj.method}{character string specifying p-value adjustment method.}

\item{transform.counts}{the type of transformation used on the counts - "logcpm" for using \code{edgeR::cpm(counts, log=TRUE)};
"cpm" for \code{edgeR::cpm(counts)}; "rpkm" for \code{edgeR::rpkm(counts)}; "logrpkm" for \code{edgeR::rpkm(counts, log=TRUE)}; and "none" for no transformation). Defaults to "logcpm".}

\item{main}{character string for the main title of summary plot.}

\item{xlab}{character string for the x-axis label of summary plot.}

\item{ylab}{character string for the y-axis label of summary plot.}

\item{html}{character string for naming HTML file for exportation of widget. The extension
should be included in the file name e.g. "file.html".}

\item{width}{numeric value indicating width of widget in pixels.}

\item{height}{numeric value indicating width of height in pixels.}

\item{...}{additional unused arguments.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Draws a two-panel interactive volcano plot from an DGEExact object. This is a special case of the
\code{glimmaXY} plot.
}
\details{
The summary plot on the left represents gene-wise log-fold-change (logFC) on the x-axis versus
    \code{-log10(pvalue)}. The expression plot on the right displays sample expression values for a single gene.
    Interactions with the htmlwidget include clicking on genes (points) in the summary plot to bring up
    associated sample expression values in the expression plot, as well as the summary statistics in the table below.
    Alternatively, users can interact with the table by clicking on genes (rows) to highlight genes in the summary plot,
    as well as bring up associated sample expression values in the expression plot.
    Briefly, other interactive features include a search box for the table, buttons to save plots and data
    (summary statistics and expression values), additional pop-up information when hovering on points in plots,
    and rescaling of the y-axis in the expression plot.
}
\examples{
dge <- readRDS(
  system.file("RNAseq123/dge.rds", package = "Glimma"))
design <- readRDS(
  system.file("RNAseq123/design.rds", package = "Glimma"))
contr.matrix <- readRDS(
  system.file("RNAseq123/contr.matrix.rds", package = "Glimma"))

dge <- edgeR::estimateDisp(dge, design)
gfit <- edgeR::glmFit(dge, design)
glrt <- edgeR::glmLRT(gfit, design, contrast = contr.matrix)

glimmaVolcano(glrt, dge = dge)

}
\seealso{
\code{\link{glimmaVolcano}}, \code{\link{glimmaVolcano.MArrayLM}}, \code{\link{glimmaVolcano.DGELRT}}, \code{\link{glimmaVolcano.DESeqDataSet}}
}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
