% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaMDS.R
\name{glimmaMDS.default}
\alias{glimmaMDS.default}
\title{Glimma MDS Plot}
\usage{
\method{glimmaMDS}{default}(
  x,
  groups = as.character(rep(1, ncol(x))),
  labels = as.character(seq_len(ncol(x))),
  continuous.colour = FALSE,
  top = 500,
  gene.selection = c("pairwise", "common"),
  html = NULL,
  width = 900,
  height = 500,
  ...
)
}
\arguments{
\item{x}{the matrix containing the gene expressions.}

\item{groups}{vector or data frame object with associated sample information such as experimental groups.
The information is displayed in mouseover tooltips, and appropriate vector(s) can be used to adjust the plot using \code{scale_by}, \code{colour_by}
and \code{shape_by} drop-down boxes of the widget.}

\item{labels}{character vector of sample names or labels.}

\item{continuous.colour}{\code{TRUE} if continuous colour schemes should be used. Defaults to \code{FALSE} where distinct colour schemes are used.}

\item{top}{integer indiating number of top genes used to calculate pairwise distances.}

\item{gene.selection}{character string specifying how genes are selected from the plot - "pairwise" if most variable genes are to be chosen for each pair of
samples,  or "common" to select the same genes for all comparisons.}

\item{html}{character string for naming HTML file or exportation of widget. The extension should be included in the file name e.g. "file.hml".}

\item{width}{numeric value indicating width of widget in pixels.}

\item{height}{numeric value indicating width of widget in pixels.}

\item{...}{additional unused arguments.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Draws a two-panel interactive MDS plot.
}
\details{
The left plot shows two MDS dimensions, with sample annotations displayed on hover.
     The right panel contains a bar plot of the eigenvalues of each dimension.
     The controls beneath the plots can be used to change the dimensions being displayed, and the scale, colour and shape of points.
     The interactive MDS plot allows users to adjust sample points by scale, colour and shape for multiple vectors associated with
     sample information. This is carried out most effectively when \code{x$samples} includes an abundance of sample information, or
     when a data frame object is supplied to \code{groups}. If a simple character or factor vector is given to \code{groups}
     (with the default of \code{continous.colour=FALSE}), then sample points will have no scaling options, but can only be adjusted
     in colour and shape by \code{groups} and \code{labels}. Instead, if \code{groups} is a numeric vector (e.g. library size or
     expression level of a specific gene), then the plot can be scaled and coloured by the numeric values with
     \code{continous.colour=TRUE}. For more details, refer to \code{limma::plotMDS} .
}
\examples{
dge <- readRDS(system.file("RNAseq123/dge.rds", package = "Glimma"))
expr <- edgeR::cpm(dge, log = TRUE)
glimmaMDS(expr)

}
\seealso{
\code{\link{glimmaMDS}}, \code{\link{glimmaMDS.DGEList}}, \code{\link{glimmaMDS.DESeqDataSet}}
}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
