% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glimmaMDS.R
\name{glimmaMDS}
\alias{glimmaMDS}
\title{Glimma MDS Plot}
\usage{
glimmaMDS(x, ...)
}
\arguments{
\item{x}{the matrix containing the gene expressions.}

\item{...}{the additional arguments affecting the plot produced. See specific methods for detailed arguments.}
}
\value{
htmlwidget object or \code{NULL} if \code{html} argument is specified.
}
\description{
Generic function for drawing a two-panel interactive multidimensional scaling (MDS) plot.
The function invokes the following methods which depend on the class of the first argument:
\itemize{
  \item \code{\link{glimmaMDS.DGEList}} for edgeR analysis
  \item \code{\link{glimmaMDS.DESeqDataSet}} for DESeq2 analysis
  \item \code{\link{glimmaMDS.default}} for all other object types }
}
\details{
The left plot shows two MDS dimensions, with sample annotations displayed on hover.
     The right panel contains a bar plot of the eigenvalues of each dimension.
     The controls beneath the plots can be used to change the dimensions being displayed, and the scale, colour and shape of points.
     The interactive MDS plot allows users to adjust sample points by scale, colour and shape for multiple vectors associated with
     sample information. This is carried out most effectively when \code{x$samples} includes an abundance of sample information, or
     when a data frame object is supplied to \code{groups}. If a simple character or factor vector is given to \code{groups}
     (with the default of \code{continous.colour=FALSE}), then sample points will have no scaling options, but can only be adjusted
     in colour and shape by \code{groups} and \code{labels}. Instead, if \code{groups} is a numeric vector (e.g. library size or
     expression level of a specific gene), then the plot can be scaled and coloured by the numeric values with
     \code{continous.colour=TRUE}. For more details, refer to \code{limma::plotMDS} .
}
\examples{

dge <- readRDS(system.file("RNAseq123/dge.rds", package = "Glimma"))
glimmaMDS(dge)

# using DESeqDataSet
dds <- DESeq2::DESeqDataSetFromMatrix(
 countData = dge$counts,
 colData = dge$samples,
 rowData = dge$genes,
 design = ~group
)
glimmaMDS(dds)

# using matrix object
expr <- edgeR::cpm(dge, log = TRUE)
glimmaMDS(expr)


}
\author{
Hasaru Kariyawasam, Shian Su and Oliver Voogd
}
